
' Leatrix Latency Fix Checker
' To use, simply run this script.
' To run from within batch files, use 'cscript Checker.vbs"

  logo = "Leatrix Latency Fix Checker"
  Leatrix_Version = "1.23"

  Const HKEY_LOCAL_MACHINE = &H80000002

  Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")
  strKeyPath = "SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\Interfaces\"
  strIPPath = "SOFTWARE\Microsoft\Windows NT\CurrentVersion\NetworkCards\"
  oReg.EnumKey HKEY_LOCAL_MACHINE, strKeyPath, arrSubKeys
  oReg.EnumKey HKEY_LOCAL_MACHINE, strIPPath, subkeylist 

  Dim Ip(99)
  Dim desc(99)
 
  If Instr(1, WScript.FullName, "cscript", vbTextCompare) > 1 Then
    Leatrix_Script = 1
  End If

  if Leatrix_Script = 1 then
    wscript.echo "Leatrix Latency Fix " & Leatrix_Version & " Batch Mode."
    wscript.echo ""
  end if

' Latency fix checker
  CheckFix Installed,Ip,desc
  if Installed = 0 then msg = "Leatrix Latency Fix is not installed on any network interfaces." end if
  if Installed > 0 then
    if Installed = 1 then interface = "interface" else interface = "interfaces" end if
    msg = "Leatrix Latency Fix is installed on " & Installed & " network " & interface & "." & vbCrLf
    if Installed > 0 then
      for k = 1 to Installed
        if desc(k) = "" or desc(k) = vbCrLf then desc(k) = "" & vbCrLf
        if Ip(k) = "0.0.0.0" then Ip(k) = "DHCP or virtual address"
		if desc(k) <> vbCrLf then
			msg = msg & vbCrLf & desc(k) & " (" & Ip(k) & ")" 
			msg = msg + vbCrLf
		end if
      next
    end if
  end if
  if Leatrix_Script = 0 then
    if Installed = 0 then no = 48 else no = 64 end if
    msg = msgbox (msg,no,logo)
  else
    wscript.echo msg
  end if
  wscript.quit

  Function CheckFix(Installed,Ip,desc)
  Installed = 0
  For Each subkey In arrSubKeys
    oReg.GetDWORDValue HKEY_LOCAL_MACHINE,strKeyPath & subkey,"TcpAckFrequency",CheckFix
    if CheckFix = 1 then
      On Error Resume Next 
      Installed = Installed + 1
      oReg.GetMultiStringValue HKEY_LOCAL_MACHINE,strKeyPath & subkey,"IPAddress",iValues
      For Each strValue In iValues
        if strValue = "" then Ip(Installed) = "Unknown" else Ip(Installed) = strValue end if
        For Each subkeyq In subkeylist
          oReg.GetStringValue HKEY_LOCAL_MACHINE,strIPPath & subkeyq,"ServiceName",CheckFixx
          if CheckFixx = subkey then 
            oReg.GetStringValue HKEY_LOCAL_MACHINE,strIPPath & subkeyq,"Description",descq
             desc(Installed) = descq & vbCrLf
          end if
        next
      next
    end if
  Next
  end function